/*
 * Decompiled with CFR 0.152.
 */
package minecraftSeed;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import minecraftSeed.DirFilter;
import minecraftSeed.Tag;
import net.miginfocom.swing.MigLayout;

public class MinecraftSeed
implements ActionListener {
    private Tag main;
    private JFrame frame;
    private JPanel panel;
    private JTextField text;
    private String savePath;
    private String[] filePaths;
    private String lastFolder;
    private int validNames;
    private JComboBox<String> combo;
    private JCheckBox cbCreative;
    private boolean creativeEnabled;
    private boolean hardcoreEnabled;
    private boolean abilitiesExist;
    private JButton btnSave;
    private String selectedFilePath;
    private final String version = "1.6.1";
    private JCheckBox cbHardcore;

    public MinecraftSeed() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            this.savePath = String.valueOf(System.getenv("APPDATA")) + "\\.minecraft\\saves\\";
        }
        if (System.getProperty("os.name").toLowerCase().contains("mac os x")) {
            this.savePath = String.valueOf(System.getProperty("user.home")) + "/Library/Application Support/minecraft/saves/";
        }
        if (System.getProperty("os.name").toLowerCase().contains("linux")) {
            this.savePath = String.valueOf(System.getProperty("user.home")) + "/.minecraft/saves/";
        }
        this.frame = new JFrame("Minecraft Save Seed Reader v1.6.1");
        this.frame.setDefaultCloseOperation(3);
        this.panel = new JPanel();
        this.combo = new JComboBox();
        this.combo.addActionListener(this);
        this.text = new JTextField();
        this.text.setColumns(20);
        this.text.setEditable(false);
        JMenuBar menuBar = new JMenuBar();
        JMenu helpMenu = new JMenu("Help");
        JMenuItem howToUse = new JMenuItem("How to use");
        howToUse.setActionCommand("use");
        howToUse.addActionListener(this);
        helpMenu.add(howToUse);
        JMenuItem newFolder = new JMenuItem("Select MC Save Folder");
        newFolder.setActionCommand("folder");
        newFolder.addActionListener(this);
        helpMenu.add(newFolder);
        helpMenu.addSeparator();
        JMenuItem about = new JMenuItem("About");
        about.setActionCommand("about");
        about.addActionListener(this);
        helpMenu.add(about);
        menuBar.add(helpMenu);
        this.frame.setJMenuBar(menuBar);
        this.panel.setLayout(new MigLayout("", "[28px][166px][95px]", "[23px][][]"));
        this.panel.add(this.combo, "cell 0 0,alignx left,aligny center");
        this.panel.add((Component)this.text, "cell 1 0 2 1,growx");
        this.frame.getContentPane().add(this.panel);
        this.cbCreative = new JCheckBox("Creative Mode");
        this.cbCreative.setEnabled(false);
        this.cbCreative.setActionCommand("creativetoggle");
        this.cbCreative.addActionListener(this);
        this.panel.add((Component)this.cbCreative, "flowx,cell 1 1,alignx left,aligny top");
        this.cbHardcore = new JCheckBox("Hardcore Mode");
        this.cbHardcore.setEnabled(false);
        this.cbHardcore.setActionCommand("hardcoretoggle");
        this.cbHardcore.addActionListener(this);
        this.panel.add((Component)this.cbHardcore, "cell 1 2");
        this.btnSave = new JButton("Save Changes");
        this.btnSave.setEnabled(false);
        this.btnSave.setActionCommand("save");
        this.btnSave.addActionListener(this);
        this.panel.add((Component)this.btnSave, "cell 2 2");
        this.setupData();
        this.frame.pack();
        this.frame.setLocationRelativeTo(null);
        this.frame.setVisible(true);
    }

    public static void main(String[] args) {
        try {
            new MinecraftSeed();
        }
        catch (Exception e) {
            try {
                FileOutputStream fos = new FileOutputStream("MinecraftSeed.error.log");
                e.printStackTrace(new PrintStream(fos));
                fos.close();
                JOptionPane.showMessageDialog(null, "An error occured.\nCheck the MinecraftSeed.error.log file for more information.", "ERROR", 0);
            }
            catch (FileNotFoundException e1) {
                e.printStackTrace();
            }
            catch (IOException e2) {
                e.printStackTrace();
            }
            e.printStackTrace();
        }
    }

    private void setupData() {
        boolean loop = false;
        do {
            loop = false;
            File file = new File(this.savePath);
            if (file.exists()) {
                String[] tempPaths = file.list(new DirFilter());
                this.filePaths = new String[tempPaths.length];
                this.validNames = 0;
                this.combo.removeAllItems();
                String[] stringArray = tempPaths;
                int n = tempPaths.length;
                int n2 = 0;
                while (n2 < n) {
                    block11: {
                        String s = stringArray[n2];
                        file = new File(String.valueOf(this.savePath) + File.separator + s + File.separator + "level.dat");
                        if (file.exists()) {
                            this.filePaths[this.validNames] = file.getPath();
                            this.lastFolder = file.getParent();
                            try {
                                FileInputStream fis = new FileInputStream(file);
                                this.main = Tag.readFrom(fis);
                                fis.close();
                                Tag name = this.main.findTagByName("LevelName");
                                if (name == null) {
                                    this.combo.addItem(file.getParentFile().getName());
                                } else {
                                    this.combo.addItem((String)name.getValue());
                                }
                            }
                            catch (FileNotFoundException e) {
                                e.printStackTrace();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            catch (Exception e) {
                                JOptionPane.showMessageDialog(this.frame, "There was a problem reading the save file in " + this.lastFolder + ".\n It will not be loaded in this program.", "Error", 0);
                                break block11;
                            }
                            ++this.validNames;
                        }
                    }
                    ++n2;
                }
                if (this.validNames > 0) {
                    this.combo.setSelectedIndex(0);
                    continue;
                }
                JOptionPane.showMessageDialog(this.panel, "No valid save files were detected in current folder.\n\nPlease choose a new one.", "Error", 0);
                if (!this.chooseSaveFolder()) continue;
                loop = true;
                continue;
            }
            JOptionPane.showMessageDialog(this.panel, "Save folder doesn't exist.\n\nPlease choose a new one.", "Error", 0);
            if (!this.chooseSaveFolder()) continue;
            loop = true;
        } while (loop);
    }

    private boolean chooseSaveFolder() {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(1);
        int ret = fc.showDialog(this.panel, "Open Minecraft Saves Folder");
        if (ret == 0) {
            this.savePath = fc.getSelectedFile().getPath();
            if (new File(String.valueOf(this.savePath) + File.separator + "level.dat").exists() && new File(String.valueOf(this.savePath) + File.separator + "session.lock").exists() && new File(String.valueOf(this.savePath) + File.separator + "region").exists()) {
                this.savePath = new File(this.savePath).getParent();
            }
            return true;
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        block22: {
            if (arg0.getSource() == this.combo) {
                int val = this.combo.getSelectedIndex();
                if (val > -1) {
                    this.btnSave.setEnabled(false);
                    try {
                        this.selectedFilePath = this.filePaths[val];
                        FileInputStream fis = new FileInputStream(new File(this.selectedFilePath));
                        this.main = Tag.readFrom(fis);
                        fis.close();
                        this.text.setText(this.main.findTagByName("RandomSeed").getValue().toString());
                        Tag creative = this.main.findTagByName("GameType");
                        if (creative == null) {
                            this.cbCreative.setEnabled(false);
                            this.cbCreative.setSelected(false);
                        } else {
                            this.cbCreative.setEnabled(true);
                            this.creativeEnabled = (Integer)creative.getValue() == 1;
                            this.cbCreative.setSelected(this.creativeEnabled);
                        }
                        Tag hardcore = this.main.findTagByName("hardcore");
                        if (hardcore == null) {
                            this.cbHardcore.setEnabled(false);
                            this.cbHardcore.setSelected(false);
                        } else {
                            this.cbHardcore.setEnabled(true);
                            this.hardcoreEnabled = (Byte)hardcore.getValue() == 1;
                            this.cbHardcore.setSelected(this.hardcoreEnabled);
                        }
                        Tag abilities = this.main.findTagByName("Player").findTagByName("abilities");
                        if (abilities == null) {
                            this.abilitiesExist = false;
                            break block22;
                        }
                        this.abilitiesExist = true;
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                String message;
                String cmd = arg0.getActionCommand();
                if (cmd.equals("use")) {
                    message = "Choose the world's name from the dropdown list.\nThe world's seed will show up in the textbox.\n\nIf the list is empty, click on Help > Select MC Save Folder,\nand find and open the saves folder in the file chooser.\n\nIf the save is a version 1.8+ save, you can switch the world\nbetween Creative and Survival by checking the checkbox, then\nhitting Save.";
                    JOptionPane.showMessageDialog(this.panel, message, "How to Use", 1);
                }
                if (cmd.equals("about")) {
                    message = "Written by Chris Iverson. \n\nSource code available here:\nhttps://github.com/thedarkfreak/Minecraft-Save-Seed-Reader\n\nProblems? \nReport them either to the github site, in the forum topic,\nor send me an e-mail at cj.no.one@gmail.com.\n\nEnjoy!";
                    JOptionPane.showMessageDialog(this.panel, message, "About Minecraft Save Seed Reader v1.6.1", 1);
                }
                if (cmd.equals("folder") && this.chooseSaveFolder()) {
                    this.setupData();
                }
                if (cmd.equals("creativetoggle")) {
                    this.creativeEnabled = !this.creativeEnabled;
                    Tag creative = this.main.findTagByName("GameType");
                    creative.setValue(this.creativeEnabled ? 1 : 0);
                    if (this.abilitiesExist) {
                        Tag abilities = this.main.findTagByName("Player").findTagByName("abilities");
                        byte enabled = (byte)(this.creativeEnabled ? 1 : 0);
                        Tag temp = abilities.findTagByName("flying");
                        temp.setValue(enabled);
                        temp = abilities.findTagByName("instabuild");
                        temp.setValue(enabled);
                        temp = abilities.findTagByName("invulnerable");
                        temp.setValue(enabled);
                        temp = abilities.findTagByName("mayfly");
                        temp.setValue(enabled);
                    }
                    this.btnSave.setEnabled(true);
                }
                if (cmd.equals("hardcoretoggle")) {
                    this.hardcoreEnabled = !this.hardcoreEnabled;
                    Tag hardcore = this.main.findTagByName("hardcore");
                    hardcore.setValue((byte)(this.hardcoreEnabled ? 1 : 0));
                    this.btnSave.setEnabled(true);
                }
                if (cmd.equals("save")) {
                    int chosen = JOptionPane.showConfirmDialog(this.frame, "Are you sure you want to overwrite your save file?", "Overwrite", 0);
                    if (chosen == 0) {
                        // empty if block
                    }
                    try {
                        FileOutputStream fos = new FileOutputStream(new File(this.selectedFilePath));
                        this.main.writeTo(fos);
                        fos.close();
                    }
                    catch (FileNotFoundException e) {
                        JOptionPane.showMessageDialog(null, "Problem saving file: File Not Found", "File Not Found", 0);
                    }
                    catch (IOException e) {
                        JOptionPane.showMessageDialog(null, "Problem saving file: IO Error", "IO Error", 0);
                    }
                    JOptionPane.showMessageDialog(this.frame, "File saved!");
                    this.btnSave.setEnabled(false);
                }
            }
        }
    }
}

