/*
 * Decompiled with CFR 0.152.
 */
package minecraftSeed;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class Tag {
    private final Type type;
    private Type listType = null;
    private final String name;
    private Object value;

    public Tag(Type type, String name, Tag[] value) {
        this(type, name, (Object)value);
    }

    public Tag(String name, Type listType) {
        this(Type.TAG_List, name, (Object)listType);
    }

    public Tag(Type type, String name, Object value) {
        switch (type) {
            case TAG_End: {
                if (value == null) break;
                throw new IllegalArgumentException();
            }
            case TAG_Byte: {
                if (value instanceof Byte) break;
                throw new IllegalArgumentException();
            }
            case TAG_Short: {
                if (value instanceof Short) break;
                throw new IllegalArgumentException();
            }
            case TAG_Int: {
                if (value instanceof Integer) break;
                throw new IllegalArgumentException();
            }
            case TAG_Long: {
                if (value instanceof Long) break;
                throw new IllegalArgumentException();
            }
            case TAG_Float: {
                if (value instanceof Float) break;
                throw new IllegalArgumentException();
            }
            case TAG_Double: {
                if (value instanceof Double) break;
                throw new IllegalArgumentException();
            }
            case TAG_Byte_Array: {
                if (value instanceof byte[]) break;
                throw new IllegalArgumentException();
            }
            case TAG_String: {
                if (value instanceof String) break;
                throw new IllegalArgumentException();
            }
            case TAG_List: {
                if (value instanceof Type) {
                    this.listType = (Type)value;
                    value = new Tag[]{};
                    break;
                }
                if (!(value instanceof Tag[])) {
                    throw new IllegalArgumentException();
                }
                this.listType = ((Tag[])value)[0].getType();
                break;
            }
            case TAG_Compound: {
                if (value instanceof Tag[]) break;
                throw new IllegalArgumentException();
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.type = type;
        this.name = name;
        this.value = value;
    }

    public Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object newValue) {
        switch (this.type) {
            case TAG_End: {
                if (this.value == null) break;
                throw new IllegalArgumentException();
            }
            case TAG_Byte: {
                if (this.value instanceof Byte) break;
                throw new IllegalArgumentException();
            }
            case TAG_Short: {
                if (this.value instanceof Short) break;
                throw new IllegalArgumentException();
            }
            case TAG_Int: {
                if (this.value instanceof Integer) break;
                throw new IllegalArgumentException();
            }
            case TAG_Long: {
                if (this.value instanceof Long) break;
                throw new IllegalArgumentException();
            }
            case TAG_Float: {
                if (this.value instanceof Float) break;
                throw new IllegalArgumentException();
            }
            case TAG_Double: {
                if (this.value instanceof Double) break;
                throw new IllegalArgumentException();
            }
            case TAG_Byte_Array: {
                if (this.value instanceof byte[]) break;
                throw new IllegalArgumentException();
            }
            case TAG_String: {
                if (this.value instanceof String) break;
                throw new IllegalArgumentException();
            }
            case TAG_List: {
                if (this.value instanceof Type) {
                    this.listType = (Type)((Object)this.value);
                    this.value = new Tag[0];
                    break;
                }
                if (!(this.value instanceof Tag[])) {
                    throw new IllegalArgumentException();
                }
                this.listType = ((Tag[])this.value)[0].getType();
                break;
            }
            case TAG_Compound: {
                if (this.value instanceof Tag[]) break;
                throw new IllegalArgumentException();
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.value = newValue;
    }

    public Type getListType() {
        return this.listType;
    }

    public void addTag(Tag tag) {
        if (this.type != Type.TAG_List && this.type != Type.TAG_Compound) {
            throw new RuntimeException();
        }
        Tag[] subtags = (Tag[])this.value;
        int index = subtags.length;
        if (this.type == Type.TAG_Compound) {
            --index;
        }
        this.insertTag(tag, index);
    }

    public void insertTag(Tag tag, int index) {
        if (this.type != Type.TAG_List && this.type != Type.TAG_Compound) {
            throw new RuntimeException();
        }
        Tag[] subtags = (Tag[])this.value;
        if (subtags.length > 0 && this.type == Type.TAG_List && tag.getType() != this.getListType()) {
            throw new IllegalArgumentException();
        }
        if (index > subtags.length) {
            throw new IndexOutOfBoundsException();
        }
        Tag[] newValue = new Tag[subtags.length + 1];
        System.arraycopy(subtags, 0, newValue, 0, index);
        newValue[index] = tag;
        System.arraycopy(subtags, index, newValue, index + 1, subtags.length - index);
        this.value = newValue;
    }

    public Tag removeTag(int index) {
        if (this.type != Type.TAG_List && this.type != Type.TAG_Compound) {
            throw new RuntimeException();
        }
        Tag[] subtags = (Tag[])this.value;
        Tag victim = subtags[index];
        Tag[] newValue = new Tag[subtags.length - 1];
        System.arraycopy(subtags, 0, newValue, 0, index);
        System.arraycopy(subtags, ++index, newValue, index - 1, subtags.length - index);
        this.value = newValue;
        return victim;
    }

    public void removeSubTag(Tag tag) {
        if (this.type != Type.TAG_List && this.type != Type.TAG_Compound) {
            throw new RuntimeException();
        }
        if (tag == null) {
            return;
        }
        Tag[] subtags = (Tag[])this.value;
        int i = 0;
        while (i < subtags.length) {
            if (subtags[i] == tag) {
                this.removeTag(i);
                return;
            }
            if (subtags[i].type == Type.TAG_List || subtags[i].type == Type.TAG_Compound) {
                subtags[i].removeSubTag(tag);
            }
            ++i;
        }
    }

    public Tag findTagByName(String name) {
        return this.findNextTagByName(name, null);
    }

    public Tag findNextTagByName(String name, Tag found) {
        Tag[] subtags;
        if (this.type != Type.TAG_List && this.type != Type.TAG_Compound) {
            return null;
        }
        Tag[] tagArray = subtags = (Tag[])this.value;
        int n = subtags.length;
        int n2 = 0;
        while (n2 < n) {
            Tag subtag = tagArray[n2];
            if (subtag.name == null && name == null || subtag.name != null && subtag.name.equals(name)) {
                return subtag;
            }
            Tag newFound = subtag.findTagByName(name);
            if (newFound != null && newFound != found) {
                return newFound;
            }
            ++n2;
        }
        return null;
    }

    public static Tag readFrom(InputStream is) throws IOException {
        DataInputStream dis = new DataInputStream(new GZIPInputStream(is));
        byte type = dis.readByte();
        Tag tag = null;
        tag = type == 0 ? new Tag(Type.TAG_End, null, null) : new Tag(Type.values()[type], dis.readUTF(), Tag.readPayload(dis, type));
        dis.close();
        return tag;
    }

    private static Object readPayload(DataInputStream dis, byte type) throws IOException {
        switch (type) {
            case 0: {
                return null;
            }
            case 1: {
                return dis.readByte();
            }
            case 2: {
                return dis.readShort();
            }
            case 3: {
                return dis.readInt();
            }
            case 4: {
                return dis.readLong();
            }
            case 5: {
                return Float.valueOf(dis.readFloat());
            }
            case 6: {
                return dis.readDouble();
            }
            case 7: {
                int length = dis.readInt();
                byte[] ba = new byte[length];
                dis.readFully(ba);
                return ba;
            }
            case 8: {
                return dis.readUTF();
            }
            case 9: {
                byte lt = dis.readByte();
                int ll = dis.readInt();
                Tag[] lo = new Tag[ll];
                int i = 0;
                while (i < ll) {
                    lo[i] = new Tag(Type.values()[lt], null, Tag.readPayload(dis, lt));
                    ++i;
                }
                if (lo.length == 0) {
                    return Type.values()[lt];
                }
                return lo;
            }
            case 10: {
                byte stt;
                Tag[] tags = new Tag[]{};
                do {
                    stt = dis.readByte();
                    String name = null;
                    if (stt != 0) {
                        name = dis.readUTF();
                    }
                    Tag[] newTags = new Tag[tags.length + 1];
                    System.arraycopy(tags, 0, newTags, 0, tags.length);
                    newTags[tags.length] = new Tag(Type.values()[stt], name, Tag.readPayload(dis, stt));
                    tags = newTags;
                } while (stt != 0);
                return tags;
            }
        }
        return null;
    }

    public void writeTo(OutputStream os) throws IOException {
        GZIPOutputStream gzos = new GZIPOutputStream(os);
        DataOutputStream dos = new DataOutputStream(gzos);
        dos.writeByte(this.type.ordinal());
        if (this.type != Type.TAG_End) {
            dos.writeUTF(this.name);
            this.writePayload(dos);
        }
        gzos.flush();
        gzos.close();
    }

    private void writePayload(DataOutputStream dos) throws IOException {
        switch (this.type) {
            case TAG_End: {
                break;
            }
            case TAG_Byte: {
                dos.writeByte(((Byte)this.value).byteValue());
                break;
            }
            case TAG_Short: {
                dos.writeShort(((Short)this.value).shortValue());
                break;
            }
            case TAG_Int: {
                dos.writeInt((Integer)this.value);
                break;
            }
            case TAG_Long: {
                dos.writeLong((Long)this.value);
                break;
            }
            case TAG_Float: {
                dos.writeFloat(((Float)this.value).floatValue());
                break;
            }
            case TAG_Double: {
                dos.writeDouble((Double)this.value);
                break;
            }
            case TAG_Byte_Array: {
                byte[] ba = (byte[])this.value;
                dos.writeInt(ba.length);
                dos.write(ba);
                break;
            }
            case TAG_String: {
                dos.writeUTF((String)this.value);
                break;
            }
            case TAG_List: {
                Tag[] list = (Tag[])this.value;
                dos.writeByte(this.getListType().ordinal());
                dos.writeInt(list.length);
                Tag[] tagArray = list;
                int n = list.length;
                int n2 = 0;
                while (n2 < n) {
                    Tag tt = tagArray[n2];
                    tt.writePayload(dos);
                    ++n2;
                }
                break;
            }
            case TAG_Compound: {
                Tag[] subtags;
                Tag[] tagArray = subtags = (Tag[])this.value;
                int n = subtags.length;
                int n3 = 0;
                while (n3 < n) {
                    Tag st;
                    Tag subtag = st = tagArray[n3];
                    Type type = subtag.getType();
                    dos.writeByte(type.ordinal());
                    if (type != Type.TAG_End) {
                        dos.writeUTF(subtag.getName());
                        subtag.writePayload(dos);
                    }
                    ++n3;
                }
                break;
            }
        }
    }

    public void print() {
        this.print(this, 0);
    }

    private String getTypeString(Type type) {
        switch (type) {
            case TAG_End: {
                return "TAG_End";
            }
            case TAG_Byte: {
                return "TAG_Byte";
            }
            case TAG_Short: {
                return "TAG_Short";
            }
            case TAG_Int: {
                return "TAG_Int";
            }
            case TAG_Long: {
                return "TAG_Long";
            }
            case TAG_Float: {
                return "TAG_Float";
            }
            case TAG_Double: {
                return "TAG_Double";
            }
            case TAG_Byte_Array: {
                return "TAG_Byte_Array";
            }
            case TAG_String: {
                return "TAG_String";
            }
            case TAG_List: {
                return "TAG_List";
            }
            case TAG_Compound: {
                return "TAG_Compound";
            }
        }
        return null;
    }

    private void indent(int indent) {
        int i = 0;
        while (i < indent) {
            System.out.print("   ");
            ++i;
        }
    }

    private void print(Tag t, int indent) {
        Type type = t.getType();
        if (type == Type.TAG_End) {
            return;
        }
        String name = t.getName();
        this.indent(indent);
        System.out.print(this.getTypeString(t.getType()));
        if (name != null) {
            System.out.print("(\"" + t.getName() + "\")");
        }
        if (type == Type.TAG_Byte_Array) {
            byte[] b = (byte[])t.getValue();
            System.out.println(": [" + b.length + " bytes]");
        } else if (type == Type.TAG_List) {
            Tag[] subtags = (Tag[])t.getValue();
            System.out.println(": " + subtags.length + " entries of type " + this.getTypeString(t.getListType()));
            Tag[] tagArray = subtags;
            int n = subtags.length;
            int n2 = 0;
            while (n2 < n) {
                Tag st = tagArray[n2];
                this.print(st, indent + 1);
                ++n2;
            }
            this.indent(indent);
            System.out.println("}");
        } else if (type == Type.TAG_Compound) {
            Tag[] subtags = (Tag[])t.getValue();
            System.out.println(": " + (subtags.length - 1) + " entries");
            this.indent(indent);
            System.out.println("{");
            Tag[] tagArray = subtags;
            int n = subtags.length;
            int n3 = 0;
            while (n3 < n) {
                Tag st = tagArray[n3];
                this.print(st, indent + 1);
                ++n3;
            }
            this.indent(indent);
            System.out.println("}");
        } else {
            System.out.println(": " + t.getValue());
        }
    }

    public static enum Type {
        TAG_End,
        TAG_Byte,
        TAG_Short,
        TAG_Int,
        TAG_Long,
        TAG_Float,
        TAG_Double,
        TAG_Byte_Array,
        TAG_String,
        TAG_List,
        TAG_Compound;

    }
}

